/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.table.VWDescriptionDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableMouseAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class VWDescriptionTableCellEditor
implements TableCellEditor,
ActionListener,
FocusListener,
KeyListener {
    private static final int CLICK_COUNT_TO_START = 2;
    private static final int VALUE_NA = 0;
    private static final int VALUE_NO_CHANGE = 1;
    private static final int VALUE_UPDATED = 2;
    private VWSessionInfo m_sessionInfo = null;
    private String m_dialogTitleText = null;
    private String m_dialogLabelText = null;
    private EventListenerList m_listenerList = null;
    private Object m_currentValue = null;
    private JTable m_table = null;
    private JTextField m_textField = null;
    private VWDescriptionDialog m_descriptionDialog = null;
    private boolean m_bStarted = false;
    private boolean m_bEnabled = false;
    private boolean m_bUpdatingValue = false;

    public VWDescriptionTableCellEditor(VWSessionInfo sessionInfo, String dialogTitleText, String dialogLabelText) {
        this.m_sessionInfo = sessionInfo;
        this.m_dialogTitleText = dialogTitleText;
        this.m_dialogLabelText = dialogLabelText;
        this.m_listenerList = new EventListenerList();
        this.m_textField = new JTextField();
        this.m_textField.addActionListener(this);
        this.m_textField.addFocusListener(this);
        this.m_textField.setEditable(false);
        this.m_textField.setText(VWResource.s_editing);
    }

    public void releaseResources() {
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(CellEditorListener.class, (CellEditorListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.m_table = null;
        if (this.m_textField != null) {
            this.m_textField.removeActionListener(this);
            this.m_textField.removeAll();
            this.m_textField = null;
        }
        if (this.m_descriptionDialog != null) {
            this.m_descriptionDialog.releaseResources();
            this.m_descriptionDialog = null;
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_table = table;
        this.m_bEnabled = true;
        this.m_bStarted = false;
        if (this.m_table != null) {
            this.m_table.addKeyListener(this);
        }
        this.m_currentValue = value;
        if (this.m_descriptionDialog == null) {
            String stringValue = "";
            if (this.m_currentValue != null && this.m_currentValue instanceof String) {
                stringValue = (String)this.m_currentValue;
            }
            this.m_descriptionDialog = new VWDescriptionDialog(this.m_sessionInfo, stringValue, this.m_dialogLabelText);
            if (this.m_dialogTitleText != null) {
                this.m_descriptionDialog.setTitle(this.m_dialogTitleText);
            }
        }
        return this.m_textField;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.add(CellEditorListener.class, listener);
    }

    public void cancelCellEditing() {
        this.m_bStarted = false;
        this.fireEditingCanceled();
        this.m_bEnabled = false;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return anEvent == null || !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= 2;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.remove(CellEditorListener.class, listener);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean retValue = true;
        int nResult = 0;
        if (this.isCellEditable(anEvent) && this.m_descriptionDialog != null) {
            this.m_descriptionDialog.setVisible(true);
            if (!this.m_descriptionDialog.isVisible()) {
                nResult = this.updateCurrentValue();
                if (nResult == 2) {
                    this.fireEditingStopped();
                } else if (nResult != 0) {
                    this.cancelCellEditing();
                }
                this.m_descriptionDialog = null;
                if (this.m_table != null && this.m_table instanceof VWTable) {
                    this.m_table.addMouseListener(new VWTableMouseAdapter((VWTable)this.m_table));
                }
            }
        }
        return retValue;
    }

    public boolean stopCellEditing() {
        if (this.m_bStarted && this.m_bEnabled) {
            int nResult = this.updateCurrentValue();
            if (nResult == 2) {
                this.fireEditingStopped();
                this.m_bStarted = false;
                this.m_bEnabled = false;
            } else if (nResult != 0) {
                this.cancelCellEditing();
            }
        }
        return !this.m_bStarted;
    }

    public void actionPerformed(ActionEvent event) {
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.m_descriptionDialog != null && this.m_descriptionDialog.isVisible()) {
            return;
        }
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (!this.m_bStarted) {
            this.shouldSelectCell(event);
            return;
        }
        if (event.getKeyChar() == '\r') {
            int result = this.updateCurrentValue();
            if (result == 2) {
                this.fireEditingStopped();
            } else if (result != 0) {
                this.cancelCellEditing();
            }
        }
    }

    private void fireEditingStopped() {
        ChangeEvent changeEvent = null;
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(changeEvent);
        }
    }

    private void fireEditingCanceled() {
        ChangeEvent changeEvent = null;
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(changeEvent);
        }
    }

    private int updateCurrentValue() {
        int nResult = 1;
        if (this.m_bUpdatingValue) {
            return 0;
        }
        this.m_bUpdatingValue = true;
        if (this.m_descriptionDialog != null) {
            if (this.m_descriptionDialog.getExitStatus() == 1) {
                nResult = 1;
            } else {
                this.m_currentValue = this.m_descriptionDialog.getStringValue();
                nResult = 2;
            }
        }
        this.m_bUpdatingValue = false;
        return nResult;
    }
}

